/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class RASMessageCatalog {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private Locale locale = Locale.getDefault();
    private MessageFormat msgFormatter = new MessageFormat("");
    private ResourceBundle msgBundle;

    public RASMessageCatalog(String string) throws MissingResourceException {
        this(string, null);
    }

    public RASMessageCatalog(ResourceBundle resourceBundle) {
        this(resourceBundle, null);
    }

    public RASMessageCatalog(String string, Locale locale) throws MissingResourceException {
        this.setLocale(locale);
        this.msgBundle = ResourceBundle.getBundle(string, this.getLocale());
    }

    public RASMessageCatalog(ResourceBundle resourceBundle, Locale locale) {
        this.setLocale(locale);
        this.msgBundle = resourceBundle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.msgFormatter.setLocale(this.locale);
    }

    public String getMessage(String string) throws MissingResourceException {
        return this.msgBundle.getString(string);
    }

    public String getMessage(String string, Object object) throws MissingResourceException {
        Object[] objectArray = new Object[]{object};
        return this.getMessage(string, objectArray);
    }

    public String getMessage(String string, Object object, Object object2) throws MissingResourceException {
        Object[] objectArray = new Object[]{object, object2};
        return this.getMessage(string, objectArray);
    }

    public String getMessage(String string, Object[] objectArray) throws MissingResourceException {
        String string2 = this.msgBundle.getString(string);
        if (objectArray != null) {
            this.msgFormatter.applyPattern(string2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer = this.msgFormatter.format(objectArray, stringBuffer, (FieldPosition)null);
            string2 = stringBuffer.toString();
        }
        return string2;
    }
}

